#############################################################################
##
## Copyright (C) 2021 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:COMM$
##
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtWebChannel, except for defaults which are replaced by "...".
"""

# Module PySide2.QtWebChannel
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.QtWebChannel


class QWebChannel(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def blockUpdates(self) -> bool: ...
    def connectTo(self, transport: PySide2.QtWebChannel.QWebChannelAbstractTransport) -> None: ...
    def deregisterObject(self, object: PySide2.QtCore.QObject) -> None: ...
    def disconnectFrom(self, transport: PySide2.QtWebChannel.QWebChannelAbstractTransport) -> None: ...
    def registerObject(self, id: str, object: PySide2.QtCore.QObject) -> None: ...
    def registerObjects(self, objects: typing.Dict[str, PySide2.QtCore.QObject]) -> None: ...
    def registeredObjects(self) -> typing.Dict[str, PySide2.QtCore.QObject]: ...
    def setBlockUpdates(self, block: bool) -> None: ...


class QWebChannelAbstractTransport(PySide2.QtCore.QObject):

    def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...

    def sendMessage(self, message: typing.Dict[str, PySide2.QtCore.QJsonValue]) -> None: ...

# eof
